""" Operations on notification objects """

from __future__ import absolute_import

from sandbox.common import api
import sandbox.common.types.user as ctu
import sandbox.common.types.notification as ctn

from .api import Api
from .common import FilterBase
from . import schemas


class NotificationList(Api.Path("/notification")):
    class Get(FilterBase):
        """ List of notification items """
        author = api.String("Search by (part of) notification author")
        recipient = api.String("Search by recipient")
        transport = api.Enum("Search by notification transport", values=ctn.Transport)
        sent = api.Boolean("Search by sent flag")
        task_id = api.Id("Search by task identifier, which created the notification", required=False)
        created = api.DateTimeRange("Search by UTC creation date range separated with `..`")

        class Ok(api.Response):
            """ Search result """
            schema = schemas.notification.NotificationList
            x_matched_records = api.Header(api.Integer("Total amount of records matched by a query"))

    class Post(api.Post):
        """ Register a new notification item """

        __security__ = ctu.Restriction.TASK

        data = schemas.notification.NotificationData(scope=api.Scope.BODY)

        class Created(api.Response):
            """ Object has been created successfully """
            location = api.Header("URL to fetch just created object's data")
            schema = schemas.notification.NotificationItem

        class Forbidden(api.Response):
            """ Allowed only with task session token """


class Notification(Api.Path("/notification/{id}")):
    class Get(api.Get):
        """ Notification detailed object fetch """
        id = api.String(required=True, scope=api.Scope.PATH)

        class Ok(api.Response):
            """ Item object """
            schema = schemas.notification.NotificationItem

        class NotFound(api.Response):
            """ No object with ID provided can be found """
