""" Operations on release objects """

from __future__ import absolute_import

from sandbox.common import api

from .api import Api
from .common import Ids
from . import schemas


class ReleaseList(Api.Path("/release")):
    class Get(api.Get):
        """
        Get request list
        """
        resource_type = api.Array(api.String, "Released resource type filter")
        task_id = Ids("Task ID filter")
        type = api.String("Release type filter (comma-separated)")
        owner = api.String("Filter by owner")
        created = api.String("Filter by creation date: pair of ISO 8601 dates separated with `..`")
        include_broken = api.Boolean("Whether to include BROKEN resources")
        arch = api.String("Resource architecture filter")
        limit = api.Integer("Maximum number of returned entries", required=True)
        offset = api.Integer("Skip this number of entries")
        order = api.Array(
            api.String, "Name of the field to sort by (`+` to sort in increasing order, `-` in decreasing)"
        )

        class Ok(api.Response):
            schema = schemas.release.ReleaseList
            x_matched_records = api.Header(api.Integer("Number of objects matched by the filter"))

    class Post(api.Post):
        """
        Create a release
        """
        body = schemas.release.ReleaseCreate("Release data", required=True, scope=api.Scope.BODY)

        class Accepted(api.Response):
            """
            Release process has started
            """
            schema = schemas.release.ReleaseCreated


class Release(Api.Path("/release/{id}")):
    class Get(api.Get):
        """
        Get release information
        """
        id = api.Id(scope=api.Scope.PATH)

        class Ok(api.Response):
            schema = schemas.release.Release

        class NotFound(api.Response):
            """Release not found"""

        class BadRequest(api.Response):
            """Incorrect ID"""
