from __future__ import absolute_import

from sandbox.common import api

from ..api import Api


class LastUpdate(Api.Schema):
    """ ABCD account last update info """
    author = api.String("Author staff login")
    timestamp = api.DateTime("Last changed")
    operation_id = api.String("Operation id")


class Account(Api.Schema):
    """ ABCD account """
    id = api.String("Account id")
    folder_id = api.String("Folder id")
    version = api.Integer("Account version")
    last_update = LastUpdate()
