from __future__ import absolute_import

from sandbox.common import api

from ..api import Api


class OAuthClientInfo(Api.Schema):
    """ Information required to generate OAuth token """

    url = api.String("OAuth server URL", required=True)
    client = api.String("Client application identifier, which is registered on a server specified", required=True)


class OAuthTokenCreate(Api.Schema):
    """
    OAuth token generation required information - either OAuth server ticket or login/password pair
    """

    code = api.String("OAuth server response code, for token by code generation")
    login = api.String("User's login, for token by login/password pair generation")
    password = api.String("User's password, for token by login/password pair generation")


class ExternalOAuthGet(Api.Schema):
    """ Get external oauth token """
    service = api.String("Service for which token generated", required=True)
    token = api.String("External oauth session token")
    job_id = api.String(
        "Unique job id for which token generated, specific to the source (task_id, bb source_id or tasklet_id)"
    )


class ExternalOAuthCreate(Api.Schema):
    """ Create external oath token """
    login = api.String("External token author", required=True)
    ttl = api.Integer("External session ttl in seconds", required=True)
    service = api.String("Service for which token generated", required=True)
    job_id = api.String(
        "Unique job id for which token generated, specific to the source (task_id, bb source_id or tasklet_id)",
        required=True
    )
    sandbox_task_id = api.Id("Sandbox task id associated with external session", required=False)


class ExternalOAuth(ExternalOAuthCreate):
    """ Model with external session fields """
    token = api.String("Unique token for external session", required=True)


class ExternalOAuthDelete(Api.Schema):
    token = api.String("Unique token for external session", required=True)
    service = api.String("Service for which token generated", required=True)


class TaskSessionGet(Api.Schema):
    token = api.String("Task session token", required=True)


class TaskSession(TaskSessionGet):
    login = api.String("Task author", required=True)
    ttl = api.Integer("Task session ttl in seconds", required=True)
    task_id = api.Id("Task id")
