from __future__ import absolute_import

import sandbox.common.types.misc as ctm
from sandbox.common import api

from ..api import Api


class BatchData(Api.Schema):
    """ Batch operation schema """
    id = api.Array(api.Id, "Identifier", required=True)
    comment = api.String("Operation comment")


class BatchResult(Api.Schema):
    """ Batch operation result """
    id = api.Id()
    status = api.Enum("Operation execution result", values=ctm.BatchResultStatus, required=True)
    message = api.String("Server message in case of error or warning")


class ClientsOpData(BatchData):
    """ Clients batch operation schema """
    id = api.Array(api.String, "Client Id", required=True)


class ClientOpResult(BatchResult):
    """ Client batch operation result """
    id = api.String()


class BucketsOpData(BatchData):
    """ Buckets batch operation schema """
    id = api.Array(api.String, "Bucket Id", required=True)


class BucketOpResult(BatchResult):
    """ Bucket batch operation result """
    id = api.String()
