from __future__ import absolute_import

import inspect
import six

from sandbox.common import api

from sandbox.web.api.v1.api import Api


class ObjectRef(Api.Schema):
    """ Object reference """

    id = api.Id()
    url = api.String("Url to get object info")


class __ListMeta(type(Api.Schema)):
    # noinspection PyMethodParameters
    def __new__(mcs, name, bases, namespace):
        if bases != (Api.Schema,) and bases[0].items is None:
            item = namespace.pop("item", None)
            assert item and inspect.isclass(item) and issubclass(item, Api.Schema), \
                "'item' must contain the schema for item of the list"
            namespace.update(items=api.Array(item, "List items"))
        return type(Api.Schema).__new__(mcs, name, bases, namespace)


class List(six.with_metaclass(__ListMeta, Api.Schema)):
    offset = api.Integer("Number of skipped items", required=True)
    limit = api.Integer("Number of items to return", required=True)
    total = api.Integer("Total number of items", required=True)
    items = None
