from __future__ import absolute_import

import sandbox.common.types.notification as ctn
from sandbox.common import api

from ..api import Api

from . import common


class NotificationBase(Api.Schema):
    # Just a bunch of common fields

    task_id = api.Id("Identifier of task which created the notification", required=False)
    transport = api.Enum("Notification transport", values=ctn.Transport, required=True)
    type = api.Enum("Notification representation kind", values=ctn.Type)
    subject = api.String("Notification subject")
    recipients = api.Array(api.String, "List of notification recipients", required=True)
    urgent = api.Boolean("The notification is important and was sent from sandbox-urgent@")


class NotificationItemBase(NotificationBase):
    # Common fields for notification item and input data

    author = api.String("Notification author")
    body = api.String("Notification contents")
    headers = api.Array(api.String, "Notification headers")
    charset = api.Enum("Notification encoding", values=ctn.Charset)
    view = api.Enum("Notification base template", values=ctn.View)
    host = api.String("Notification host")
    check_status = api.Enum("Juggler event status", values=ctn.JugglerStatus)
    juggler_tags = api.Array(api.String, "List of tags for Juggler")


class NotificationListItemBase(NotificationBase):
    # Common fields for single notification item or grouped in a list

    created = api.DateTime("Notification creation date")
    id = api.String("Notification identifier")
    sent = api.Boolean("Whether the notification is sent")


class NotificationData(NotificationItemBase):
    """ Data to create notification from """


class NotificationItem(NotificationItemBase, NotificationListItemBase):
    """ Single notification object """

    inconsistent = api.Boolean("Flag used by a service thread to mark inconsistent notifications")


class NotificationListItem(NotificationListItemBase):
    """ Shortened notification info """

    url = api.String("URL with full notification data")


class NotificationList(common.List):
    """ Notification list """

    item = NotificationListItem
