from __future__ import absolute_import

from sandbox.common import api

from ..api import Api

from . import common


class ReleaseTemplate(Api.Schema):
    """
    Hints for fill-in of release creation form
    """
    types = api.Array(api.String, "Types of releases", required=True)
    cc = api.Array(api.String, "Notification recipient")
    subject = api.String("Notification subject")
    message = api.String("Notification body")


class ReleaseResource(Api.Schema):
    """
    Resource ID and users who are allowed to release it
    """
    resource_id = api.Id("Resource ID")
    type = api.String("Resource type")
    description = api.String("Resource description")
    releasers = api.Array(api.String, "Users allowed to release resource")


class Release(Api.Schema):
    """
    Information about task release
    """
    resources = api.Array(ReleaseResource)
    warning = api.String("Release warning message")
    author = api.String("Release author")
    type = api.String("Release type")
    created = api.DateTime("Date of creation")
    subject = api.String("Release notification subject")
    message = api.String("Release notification body")


class ReleaseCreate(Api.Schema):
    """
    Information about release on creation
    """
    to = api.Array(api.String, "Notification recipients")
    cc = api.Array(api.String, "Notification cc")
    subject = api.String("Release notification subject", required=True)
    message = api.String("Release notification body")
    type = api.String("Release type", required=True)
    task_id = api.Id("Task ID")
    params = api.Object("Additional parameters passed into on_release")


class ReleaseListItem(Api.Schema):
    """
    Information about release
    """
    task_id = api.Id("Task ID")
    type = api.String("Release type", required=True)
    subject = api.String("Release notification subject", required=True)
    author = api.String("Release author", required=True)
    created = api.DateTime("Date of creation", required=True)


class ReleaseList(common.List):
    item = ReleaseListItem


class ReleaseCreated(Api.Schema):
    message = api.String("Release message")
