from __future__ import absolute_import

from sandbox.common import api

from ..api import Api

from . import task
from . import user
from . import group


class QuicksearchSuggestObjectMatchHighlight(Api.Schema):
    """ Information to show search request substring match """
    type = api.Array(
        api.Array(api.Integer),
        "List of tuples (first and last symbol) of a substring matched in an object type"
    )
    description = api.Array(
        api.Array(api.Integer),
        "List of tuples (first and last symbol) of a substring matched in an object description"
    )


class QuicksearchSuggestObjectMatch(Api.Schema):
    """ Information to show search request match """
    highlights = QuicksearchSuggestObjectMatchHighlight(required=True)
    score = api.Number("Total match score", required=True)


class QuicksearchSuggestObject(Api.Schema):
    """ Object match """
    id = api.Id()
    url = api.String("Link to fetch an object data", required=True)
    type = api.String("Object class (type)", required=True)
    status = api.String("Object state (status)", required=True)
    owner = api.String("Object owner", required=True)
    match = QuicksearchSuggestObjectMatch(required=True)


class SuggestType(Api.Schema):
    """ Class (type) object match details """
    type = api.String("Class (type) of the object", required=True)
    color = api.String("Color of the type to show it on statistics graphs", required=True)
    owners = api.Array(api.String, "List of type owners", required=True)
    relative_path = api.String("Relative path to type class' file")
    description = api.String("Description taken from class' docstring")
    client_tags = api.String("Task client tags")


class SuggestGroup(Api.Schema):
    """ Users group match details """

    url = api.String("URL to fetch object data", required=True)
    name = api.String("Group name", required=True)
    priority_limits = group.GroupPriorityLimits(
        "Maximum allowed task priority limits, which can be assigned by this group's member",
        required=True
    )


class SuggestGroupWithQuota(SuggestGroup):
    quota = user.QuotaInfoShort("Information about group quota consumption", required=False)


class QuicksearchSuggest(Api.Schema):
    """ Quick search hints variants """

    task = QuicksearchSuggestObject("Task object match")
    task_type = SuggestType("Task type match")
    resource = QuicksearchSuggestObject("Resource object match")
    resource_type = SuggestType("Resource type match")
    group = SuggestGroup("Group name match")


class SuggestClient(Api.Schema):
    """ Allowed variant of client ID, CPU model and platform selection for the given request """

    platforms = api.Array(api.String, "List of allowed platforms for the filter specified", required=True)
    cpu_models = api.Array(api.String, "List of allowed CPU models for the filter specified", required=True)
    hosts = api.Array(api.String, "List of allowed client IDs for the filter specified", required=True)


class SuggestEnumItem(Api.Schema):
    """ Enumeration element """

    name = api.String("Name of the element", required=True)
    description = api.String("Element description")


class SuggestEnumGroup(Api.Schema):
    """ Enumerations group """

    name = api.String("Group name", required=True)
    description = api.String("Group description")
    primary = api.Boolean("Primary group mark", required=True)
    items = api.Array(api.String, "List of group's elements")


class SuggestEnum(Api.Schema):
    """ Available enumerations and enumeration groups """

    items = api.Array(SuggestEnumItem, "List of available enumerations", required=True)
    groups = api.Array(SuggestEnumGroup, "List of available enumeration groups", required=True)


class SuggestCustomFieldMeta(task.TaskCustomFieldMetaBase):
    pass


class SuggestTaskTag(Api.Schema):
    """ Task tag """
    tag = api.String("Tag name", required=True)
    hits = api.Integer("Number of hits", required=True)


class SuggestTemplate(Api.Schema):
    alias = api.String("Template alias", required=True)
    task_type = api.String("Template task type", required=True)
    description = api.String("Template description")
