from __future__ import absolute_import

import sandbox.common.types.user as ctu
from sandbox.common import api

from ..api import Api


class OwnerRating(Api.Schema):
    """
    Owner's position and total size of the quota consumption rating and some useful fields
    """
    index = api.Integer("Position in the rating")
    total = api.Integer("Total rating size")
    queue_size = api.Integer("Number of tasks in queue")
    executing_jobs = api.Integer("Number of currently executing jobs")


class QuotaConsumption(Api.Schema):
    """
    Owner's consumption of the computational resources
    """
    real = api.Integer("Real consumption")
    future = api.Integer("Future consumption")


class QuotaInfoInPool(Api.Schema):
    """
    Owner's computational quota and consumption in bool, in milliQP
    """
    pool = api.String("Pool name")
    consumption = QuotaConsumption()
    limit = api.Integer("Limit")
    rating = OwnerRating()


class QuotaInfo(Api.Schema):
    """
    Owner's computational quota and consumption, in milliQP
    """
    consumption = QuotaConsumption()
    limit = api.Integer("Limit")
    rating = OwnerRating()
    pools = api.Array(QuotaInfoInPool, "Quota by pools")


class QuotaInfoShortInPool(Api.Schema):
    """
    Owner's computational quota and consumption in pool, without rating
    """
    pool = api.String("Pool name")
    consumption = QuotaConsumption()
    limit = api.Integer("Limit")


class QuotaInfoShort(Api.Schema):
    """
    Owner's computational quota and consumption, without rating
    """
    consumption = QuotaConsumption()
    limit = api.Integer("Limit")
    pools = api.Array(QuotaInfoShortInPool, "Quota by pools")


class User(Api.Schema):
    """
    Information about user
    """
    login = api.String("Current user's login", required=True)
    role = api.Enum(
        "Current user's role; trusted users can set tasks' priority higher than USER.NORMAL",
        required=True,
        values=ctu.Role
    )
    quota = QuotaInfoShort()


class Robot(Api.Schema):
    """ Robot info """

    login = api.String("Robot login", required=True)
