from __future__ import absolute_import

import sandbox.common.types.user as ctu
from sandbox.common import api

from ..api import Api

from . import common


class VaultBase(Api.Schema):
    name = api.String("Element name", required=True)
    owner = api.String("User or group, who can modify element's data", required=True)
    shared = api.Array(api.String, "List of users or groups, who can read element's data")
    description = api.String("Description of vault record")


class VaultListItem(VaultBase):
    """ Vault item info """

    id = api.Id()
    url = api.String("URL to fetch an element object", required=True)
    rights = api.Enum("Allowed rights on the object for the current user", values=ctu.Rights)


class Vault(VaultListItem):
    """ Vault item info with data length included """
    data_length = api.Integer("Element's data size in bytes", required=True)


class VaultCreate(VaultBase):
    """ New vault item creation data """

    data = api.String("Vault data to be stored", required=True)


class VaultUpdate(Api.Schema):
    name = api.String("Element name")
    owner = api.String("User or group, who can modify element's data")
    data = api.String("Vault data to be stored")
    shared = api.Array(api.String, "List of users or groups, who can read element's data")
    description = api.String("Description of vault record")


class VaultList(common.List):
    item = VaultListItem


class VaultData(VaultBase):
    """ Vault item with data """
    id = api.String("May be vault id or yav secret id with version and key")
    data = api.String("Encrypted vault data")
