from __future__ import absolute_import

from sandbox.common import api
from ..api import Api


# Input schemas

class Secret(Api.Schema):
    """ Secret uuid only """
    id = api.String("Secret uuid", required=True)


class SecretAndVersion(Secret):
    """ Secret uuid with an optional version """
    version = api.String("Secret version", required=False)


class SecretList(Api.Schema):
    secrets = api.Array(Secret)


class SecretAndVersionList(Api.Schema):
    secrets = api.Array(SecretAndVersion)


# Output schemas

class SecretStatus(Api.Schema):
    secret = api.String("Secret uuid", required=True)
    delegated = api.Boolean("Indicates if the secret is delegated to Sandbox", required=True)


class SecretStatusList(Api.Schema):
    items = api.Array(items=SecretStatus)


class DelegationResult(SecretStatus):
    message = api.String("Delegation result: either `ok` or an error from Yav API")


class DelegationResultList(Api.Schema):
    items = api.Array(items=DelegationResult)


class EncryptedSecretData(SecretAndVersion):
    """ Secret uuid, version, and its encrypted values """
    data = api.String("Encrypted secret data", required=True)


class EncryptedSecretDataList(Api.Schema):
    items = api.Array(EncryptedSecretData)


class SecretValue(Api.Schema):
    key = api.String("Key of secret value", required=True)
    value = api.String("Secret value", required=True)
    encoding = api.String("Encoding, one of ['', 'base64']")


class SecretData(SecretAndVersion):
    """ Secret uuid, version, and its values """
    values = api.Array(SecretValue, "Values of secret")


class SecretDataList(Api.Schema):
    items = api.Array(SecretData)


class SecretInfoBase(Api.Schema):
    id = api.String("Secret uuid", required=True)
    name = api.String("Alias", required=True)
    comment = api.String("Comment", required=True)
    author = api.String("Author", required=True)
    updated_at = api.DateTime("Last updated", required=True)
    delegated = api.Boolean("Delegated to Sandbox", required=True)


class SecretSuggestList(Api.Schema):
    items = api.Array(SecretInfoBase)
    limit = api.Integer("Page size")
    page = api.Integer("Number of page")


class VersionInfo(Api.Schema):
    version = api.String("Secret version", required=True)
    author = api.String("Version author", required=True)
    comment = api.String("Comment", required=True)
    created_at = api.DateTime("Created", required=True)
    keys_ = api.Array(api.String, "Keys list", required=True)


class SecretInfo(SecretInfoBase):
    versions = api.Array(VersionInfo)
