""" A handful of handles related to statistics collection and processing """

# TODO: SANDBOX-4568 fill this module with more than one schema description
# TODO: besides, it's probably worth moving a couple of such handlers from api.json.service to api.json.statistics
# TODO: (alternatively, change their paths, but that may break something in external systems, like Golovan)

from __future__ import absolute_import

from sandbox.common import api
import sandbox.common.types.user as ctu

from .api import Api


class ServiceStatisticsAPI(Api.Path("/statistics/{signal_type}")):

    class Post(api.Post):
        """
        Save incoming raw signal
        Accept a list of arbitrary signals represented by a dictionary,
        and save them into an intermediate database without processing.
        Details: yasandbox.services.statistics_processor and common.statistics modules,
        https://st.yandex-team.ru/SANDBOX-4457.
        """

        __security__ = (ctu.Restriction.ADMIN, ctu.Restriction.TASK, ctu.Restriction.STATISTICS)

        signal_type = api.String("Signal type", required=True, scope=api.Scope.PATH)
        body = api.Array(api.Object, scope=api.Scope.BODY)

        class Created(api.Response):
            """ Signal is successfully saved """

        class Forbidden(api.Response):
            """ This method may be called with a task session or administrative token only """


class StatisticsExecutionOvertime(Api.Path("/statistics/tasks/execution_overtime")):

    class Get(api.Get):
        """ Statistics of overtime of executing tasks. Response is in format suitable for yasm. """

        class Ok(api.Response):
            schema = api.Array(api.Array(api.String, "Pair: metric name and value"))
