"""
Search result suggests
"""
from __future__ import absolute_import

from sandbox.common import api

from .api import Api
from . import schemas


class SuggestQuicksearch(Api.Path("/suggest/quicksearch/{query}")):
    class Get(api.Get):
        """ Suggests for quicksearch """

        query = api.String("Search query", required=True, scope=api.Scope.PATH)
        limit = api.Integer("Records to return limit for each block", default=3)

        class Ok(api.Response):
            """ Search result """
            schema = api.Array(schemas.suggest.QuicksearchSuggest)


class SuggestTask(Api.Path("/suggest/task")):
    class Get(api.Get):
        """ Suggests for task type selection - a list of all known task types """
        type = api.String("Request for specific task type")
        resource_id = api.Id("Resource with binary tasks", required=False)

        class Ok(api.Response):
            """ Search result """
            schema = api.Array(schemas.suggest.SuggestType)

        class BadRequest(api.Response):
            pass


class SuggestTaskStatus(Api.Path("/suggest/task/status")):
    class Get(api.Get):
        """ A list of all known task statuses and their groups """

        class Ok(api.Response):
            schema = schemas.suggest.SuggestEnum


class SuggestResourceStatus(Api.Path("/suggest/resource/status")):
    class Get(api.Get):
        """ A list of all known resource statuses"""

        class Ok(api.Response):
            schema = schemas.suggest.SuggestEnum


class SuggestTaskReqDNS(Api.Path("/suggest/task/requirements/dns")):
    class Get(api.Get):
        """ A list of task DNS settings requirements """

        class Ok(api.Response):
            schema = schemas.suggest.SuggestEnum


class SuggestTaskTags(Api.Path("/suggest/task/tags")):
    class Get(api.Get):
        """ Suggest task tags """

        query = api.String("Tag query", required=True, scope=api.Scope.QUERY)
        limit = api.Integer("Maximum number of returned items", required=False, default=10, scope=api.Scope.QUERY)

        class Ok(api.Response):
            """ Search result """
            schema = api.Array(schemas.suggest.SuggestTaskTag)


class SuggestTaskTagsByPrefix(Api.Path("/suggest/task/tags/{prefix}")):
    class Get(api.Get):
        """ [DEPRECATED] Get task tags matching by prefix """

        prefix = api.String("Search tags by prefix", required=True, scope=api.Scope.PATH)
        limit = api.Integer("Limit number of returned items", required=False, default=10, scope=api.Scope.QUERY)

        class Ok(api.Response):
            """ Search result """
            schema = api.Array(schemas.suggest.SuggestTaskTag)


class SuggestResource(Api.Path("/suggest/resource")):
    class Get(api.Get):
        """ Suggests for resource type selection - a list of all known resource types """
        type = api.String("Request for specific resource type")

        class Ok(api.Response):
            """ Search result """
            schema = api.Array(schemas.suggest.SuggestType)

        class BadRequest(api.Response):
            pass


class SuggestGroup(Api.Path("/suggest/group")):
    class Get(api.Get):
        """ Suggests for group selection - a list of all known groups """

        class Ok(api.Response):
            schema = api.Array(schemas.suggest.SuggestGroup)


class SuggestClient(Api.Path("/suggest/client")):
    class Get(api.Get):
        """
        Suggests for client selection - a list of all known client identifiers, CPU models and plaforms
        matched the query specified.
        """
        task_type = api.String("Task type to filter clients which can execute it")
        platform = api.String("Platform name filter")
        cpu = api.String("CPU model filter")
        host = api.String("Client identifier filter")

        class Ok(api.Response):
            """ Search result """
            schema = schemas.suggest.SuggestClient


class SuggestClientTag(Api.Path("/suggest/client/tag")):
    class Get(api.Get):
        """ A list of all known client tags and their groups """

        class Ok(api.Response):
            schema = schemas.suggest.SuggestEnum


class SuggestReleaseStatus(Api.Path("/suggest/release/status")):
    class Get(api.Get):
        """ A list of all known release statuses """

        class Ok(api.Response):
            schema = schemas.suggest.SuggestEnum


class SuggestSchedulerStatus(Api.Path("/suggest/scheduler/status")):
    class Get(api.Get):
        """ A list of all known scheduler statuses """

        class Ok(api.Response):
            schema = schemas.suggest.SuggestEnum


class SuggestCustomFields(Api.Path("/suggest/{type}/custom_fields")):
    class Get(api.Get):
        """
        A list of custom fields of a task's type
        Looks a lot like that for a task, but includes fields that are hidden in UI.
        """

        type = api.String("Task type", required=True, scope=api.Scope.PATH)

        class Ok(api.Response):
            schema = api.Array(schemas.suggest.SuggestCustomFieldMeta)

        class NotFound(api.Response):
            """ No such task type """


class SuggestTemplate(Api.Path("/suggest/template")):
    class Get(api.Get):
        class Ok(api.Response):
            """ Search result """
            schema = api.Array(schemas.suggest.SuggestTemplate)

        class BadRequest(api.Response):
            pass


class SuggestPlatforms(Api.Path("/suggest/platforms")):
    class Get(api.Get):
        """ A list of all available platforms """
        class Ok(api.Response):
            schema = schemas.suggest.SuggestEnum
