""" Operations on template objects (Not implemented)"""

from __future__ import absolute_import

from sandbox.common import api
import sandbox.common.types.user as ctu

from .common import FilterBaseMultiOrder

from .api import Api
from . import schemas


class TemplateList(Api.Path("/template")):
    class Get(FilterBaseMultiOrder):
        """ Get template list """

        alias = api.String("Template alias")
        author = api.String("Template author")
        shared_with = api.String("Name of user or group with write access to template")
        favorites = api.String("Name of user with template in favorites")
        task_type = api.Array(api.String, "The task name for the template")
        status = api.Array(api.String, "Template status")
        fields = api.Array(api.String, "Choose only these fields")

        class Ok(api.Response):
            schema = schemas.template.TemplateList

    class Post(api.Post):
        """ Create a new template """
        __security__ = ctu.Restriction.AUTHENTICATED

        data = schemas.template.TemplateCreate(scope=api.Scope.BODY)

        class Created(api.Response):
            """ Template has been created successfully """
            schema = schemas.template.Template
            location = api.Header("URL to fetch just created object's data")


class Template(Api.Path("/template/{alias}")):
    class Get(api.Get):
        """ Template information """
        alias = api.String("Template alias", scope=api.Scope.PATH, required=True)
        fields = api.Array(api.String, "Choose only these fields")

        class Ok(api.Response):
            schema = schemas.template.Template

        class NotFound(api.Response):
            """ Template not found """

    class Put(api.Put):
        """ Change template """
        __security__ = ctu.Restriction.AUTHENTICATED

        alias = api.String("Template alias", scope=api.Scope.PATH, required=True)
        body = schemas.template.TemplateUpdate(scope=api.Scope.BODY, required=False)

        class NoContent(api.Response):
            """ Operation is successful """

        class Forbidden(api.Response):
            """ Operation is not permitted """

        class NotFound(api.Response):
            """ Template not found """

    class Delete(api.Delete):
        """ Delete template """
        __security__ = ctu.Restriction.AUTHENTICATED

        alias = api.String("Template alias", scope=api.Scope.PATH, required=True)

        class NoContent(api.Response):
            """ Operation is successful """

        class Forbidden(api.Response):
            """ Operation is not permitted """

        class NotFound(api.Response):
            """ Template not found """


class TemplateFavorites(Api.Path("/template/{alias}/favorite")):
    class Post(api.Post):
        """ Add template to favorites of request author """
        __security__ = ctu.Restriction.AUTHENTICATED

        alias = api.String("Template alias", scope=api.Scope.PATH, required=True)

        class NoContent(api.Response):
            """ Operation is successful """

        class NotFound(api.Response):
            """ Template not found """

    class Delete(api.Delete):
        """ Delete template from favorites of request author """
        __security__ = ctu.Restriction.AUTHENTICATED

        alias = api.String("Template alias", scope=api.Scope.PATH, required=True)

        class NoContent(api.Response):
            """ Operation is successful """

        class NotFound(api.Response):
            """ Template not found """


class TemplateAuditList(Api.Path("/template/audit")):
    class Get(FilterBaseMultiOrder):
        """ Get template list """

        template_alias = api.String("Template alias")
        author = api.String("Author of changes")
        date = api.DateTimeRange("Filter by change time: pair of ISO 8601 dates separated with `..`")

        class Ok(api.Response):
            schema = schemas.template.TemplateAuditList
