"""
Batch operations on various objects
"""
from __future__ import absolute_import

from sandbox.common import api

from .api import Api
from . import schemas


class BatchRequest(Api.Path("/batch")):
    class Put(api.Put):
        """ Run any REST requests in batch """
        fail_fast = api.Boolean("Stop and cancel further subrequests at first failure", default=False)
        data = schemas.batch.BatchSubRequest("List of subrequests", required=True, scope=api.Scope.BODY)

        class Ok(api.Response):
            """ List of subresponses """
            schema = api.Array(schemas.batch.BatchSubResponse)
