from __future__ import absolute_import

import sandbox.common.types.misc as ctm

from sandbox.common import api
from ..api import Api


class BatchSubRequest(Api.Schema):
    """ Batch REST subrequest """
    method = api.Enum("HTTP method", values=ctm.RequestMethod, required=True)
    path = api.String("Request path", required=True)
    params = api.Object("Request query parameters")
    headers = api.Object("Request headers")
    data = api.Object('JSON request body')


class BatchSubResponse(Api.Schema):
    """ Batch REST subresponse """
    status = api.Integer("HTTP status", required=True)
    response = api.DataType("Response body", required=True, default=None)
    headers = api.Object("Request headers")
