import tornado.web

from sandbox import common
import sandbox.common.types.misc as ctm


class SandboxApp(tornado.web.Application):
    def __init__(self, *args, **kwargs):
        super(SandboxApp, self).__init__(*args, **kwargs)
        # special log file for golovan to build charts
        from common.log import get_server_log
        self.golovan_log = get_server_log(common.config.Registry().server.log.access_log_name)
        self.server = None

    def log_request(self, handler):
        request_time = 1000.0 * handler.request.request_time()
        usr = getattr(handler, "user", None)
        rtype = getattr(handler, "source", "web")
        self.golovan_log.info(
            "%r [%s%s%s] {%s} %s %s (%s) \"%s@%s\" \"%s\" %.2fms %s",
            handler.get_status(),
            rtype[0], ("h" if getattr(handler, "hp", False) else "l"), getattr(handler, "rp", "d"),
            getattr(handler, "id", None),
            handler.request.method, handler.request.uri, handler.remote_ip,
            handler.request.headers.get(ctm.HTTPHeader.COMPONENT, "x"),
            handler.request.headers.get(ctm.HTTPHeader.USER_AGENT, "-"),
            (usr.login if usr else "-"),
            request_time,
            "dump ID " + getattr(handler, "profid") if hasattr(handler, "profid") else "",
        )

    def listen(self, port, address="", **kwargs):
        """
        Starts an HTTP server for this application on the given port.
        """
        import tornado.netutil
        import tornado.httpserver
        self.server = tornado.httpserver.HTTPServer(self, **kwargs)
        # Instead of calling `self.server.listen(port, address)` I have to place that method's
        # implementation here, because there's no any other way to adjust backlog size.
        self.server.add_sockets(tornado.netutil.bind_sockets(port, address=address, backlog=5))

    def stop(self):
        """
        Stops listening for new connections.
        Requests currently in progress will continue after the server is stopped.
        """
        if self.server:
            self.server.stop()
