import abc


class BaseMapper(object):
    def __init__(self):
        self._field_mappers = None

    @abc.abstractproperty
    def mapper_context(self):
        pass

    @abc.abstractmethod
    def get_base_fields(self):
        pass

    def _build_field_mappers(self, fields):
        field_mappers_defs = self.mapper_context.get_field_mappers_defs()
        field_mappers = {}
        for field in fields:
            if field not in field_mappers_defs:
                # Field not found, try to find enclosing field group
                # E.g. "execution.started -> execution"
                full_field = field
                while "." in field:
                    field = field.rsplit(".", 1)[0]
                    if field in field_mappers_defs:
                        break
                else:
                    # Unknown field, return None as value
                    def none(self):
                        return None

                    field_mappers[full_field] = none
                    continue

            field_mappers[field] = field_mappers_defs[field]

        return field_mappers

    def dump(self, doc, legacy=True):
        # Shared state for all value getters
        ctx = self.mapper_context(self, doc, legacy=legacy)

        result = {}
        for field, value_getter in self._field_mappers.iteritems():
            # create sub-documents if fields are nested
            path = field.split(".")
            sub_result = result
            for item in path[:-1]:
                sub_result = sub_result.setdefault(item, {})
            # put result to the deepest one
            sub_result[path[-1]] = value_getter(ctx)

        return result
