import re
import json
import collections

import sandbox.common.types.user as ctu
import sandbox.common.types.misc as ctm


# Global registry of annotated JSON API handlers.
COMMON_PREFIX = "/api"
DOCS_ROOT = "swagger.json"
REGISTERED_JSON = []

RegistryEntry = collections.namedtuple(
    "RegistryEntry", ("regexp", "handler", "method", "restriction", "allow_ro", "version")
)


def registered_json(
    path, method=ctm.RequestMethod.GET, restriction=ctu.Restriction.ANY, allow_ro=False, version=None
):
    if path.endswith('/'):
        path = path[:-1]

    def decorator(f):
        REGISTERED_JSON.append(
            RegistryEntry(re.compile('^{}$'.format(path)), f, method, restriction, allow_ro, version)
        )
        return f
    return decorator


def api_docs(path, version="v1.0"):
    if path != DOCS_ROOT:
        return None
    import web.api.v1
    import web.helpers
    data = web.api.v1.Api.dict
    if not data:
        return None
    return web.helpers.response_ok("application/json", json.dumps(data, ensure_ascii=False).encode("utf8"))
