from sandbox.yasandbox import controller

from sandbox.yasandbox.api.json import registry
from sandbox.yasandbox.api.json import misc


@registry.registered_json('db/current_op')
def db_statistics(request):
    """Database current operations stats"""
    stat = controller.Statistics.current_db_operations_statistics()
    return misc.response_json(stat)


@registry.registered_json('db/size')
def db_size(request):
    """Database size stats"""
    stat = controller.Statistics.db_size()
    return misc.response_json(stat)


@registry.registered_json('tasks/enqueued/cpu_preferences')
def enqueued_tasks_statistics(request):
    """Amount of enqueued tasks on each cpu model"""
    stat = controller.Statistics.get_statistics(key=controller.Statistics.Keys.ENQUEUED_TASKS)
    return misc.response_json(stat)


@registry.registered_json('storage/size')
def storages_resources_statistics(request):
    """Sandbox storage statistics: amount/size of resources, disk usage stats"""
    stat = controller.Statistics.get_statistics(key=controller.Statistics.Keys.STORAGE)
    return misc.response_json(stat)


@registry.registered_json('tasks/enqueued/queue_time')
def tasks_enqueue_time(request):
    """Total queue time in seconds"""
    data = controller.Statistics.get_statistics(key=controller.Statistics.Keys.ENQUEUE_TIME)
    total_time = sum(map(lambda x: (x.values() or [0])[0], data.get("last_hour_timings", [])))
    return misc.response_json({"enqueue_time_in_last_hour": total_time / 3600})
