import inspect
import functools


XMLRPC_METHODS = {}
RO_ALLOWED_METHODS = set()


def xmlrpc_method(alias=None, protected=False, ro_allowed=False):
    def decorator(f):
        @functools.wraps(f)
        def wrapped(*args, **kwargs):
            return f(*args, **kwargs)
        # add func_name and func_obj do functions dict
        XMLRPC_METHODS[f.__name__] = f
        if alias:
            XMLRPC_METHODS[alias] = f
        # authorization required
        if protected:
            f.protected = True
        # ro allowed
        if ro_allowed:
            RO_ALLOWED_METHODS.add(f.__name__)
            if alias:
                RO_ALLOWED_METHODS.add(alias)
        # try to find request as first function argument
        argspec = inspect.getargspec(f)
        try:
            if argspec.args.index('request') == 0:
                f.request = True
        except ValueError:
            pass
        #
        return wrapped
    return decorator
