"""
Controllers over models

Module dependents:
* model
"""

from .yav import Yav
from .state import State
from .vault import Vault
from .client import Client
from .resource import Resource, ResourceLinks
from .settings import Settings
from .scheduler import Scheduler
from .semaphore import Semaphore
from .statistics import Statistics
from .notification import Notification
from .uinotification import UINotification
from .task import Task, TaskQueue, TaskWrapper
from .template import TemplateWrapper, Template
from .task_status_event import TaskStatusEvent
from .user import User, Group, OAuthCache, GroupCache, validate_credentials, user_has_permission
from .trigger import TimeTrigger, TaskStatusTrigger, TaskStatusNotifierTrigger, TaskOutputTrigger

__all__ = [
    "User", "Group", "GroupCache", "OAuthCache", "validate_credentials", "user_has_permission",
    "State",
    "Vault", "Yav",
    "TimeTrigger", "TaskStatusTrigger", "TaskStatusNotifierTrigger", "TaskOutputTrigger",
    "UINotification",
    "TemplateWrapper", "Template",
    "Notification", "Resource", "ResourceLinks",
    "Task", "TaskQueue", "TaskWrapper", "Settings",
    "Statistics",
    "Scheduler",
    "Semaphore",
    "Client",
    "TaskStatusEvent",
]


def initialize():
    from sandbox.yasandbox.database import mapping
    mapping.ensure_connection()

    Client.initialize()
    User.initialize()
    Group.initialize()
    OAuthCache.initialize()
    Vault.initialize()
    TimeTrigger.initialize()
    TaskStatusTrigger.initialize()
    TaskStatusNotifierTrigger.initialize()
    Template.initialize()
    TaskOutputTrigger.initialize()
    UINotification.initialize()
    Notification.initialize()
    Resource.initialize()
    Task.initialize()
    Scheduler.initialize()
    Semaphore.initialize()
    Settings.initialize()
    State.initialize()
    TaskStatusEvent.initialize()
