import datetime as dt

from sandbox.yasandbox.database import mapping


class TaskStatusEvent(object):
    @classmethod
    def initialize(cls):
        """
        initialize db for NotifyQueue model
        """
        mapping.TaskStatusEvent.ensure_indexes()

    @classmethod
    def create(cls, task, status):  # type: (mapping.Task, ctt.Status) -> List[str]
        """
        Creates TaskStatusEvent record in the DB.

        :param task: mapping.Task entity
        :param status: Status the task is being switched to
        :return: task.status_events with new element
        """
        now = dt.datetime.utcnow()
        db_entity = mapping.TaskStatusEvent(
            created=now,
            task_id=task.id,
            status=status,
            tags=task.tags[:],
            hints=task.hints[:]
        )
        inserted = db_entity.save()

        status_events_ids = task.status_events[:]
        status_events_ids.append(str(inserted.id))
        return status_events_ids
