import six

from infi.clickhouse_orm import engines


class DistributedEngine(engines.Engine):
    """
    A simple engine for distributed tables.
    You never need to use it directly -- see usage example in metaclass of
    `sandbox.yasandbox.database.clickhouse.models.DistributedModel`
    """

    def __init__(self, underlying_table, sampling_expr):
        for argument, argname in zip(
            (underlying_table, sampling_expr),
            six.get_function_code(DistributedEngine.__init__).co_varnames[1:]
        ):
            assert isinstance(argument, six.string_types), "{!r} parameter must be a string".format(argname)
        self.underlying_table = underlying_table
        self.sampling_expr = sampling_expr

    def create_table_sql(self, db, cluster_name):
        return "ENGINE = Distributed(`{}`, `{}`, `{}`, {})".format(
            cluster_name,
            db.db_name,
            self.underlying_table,
            self.sampling_expr
        )
