import datetime as dt
import mongoengine as me


class ABCDAccount(me.EmbeddedDocument):
    """ Fields required for ABCD provider API """

    class LastUpdate(me.EmbeddedDocument):
        author = me.StringField()
        timestamp = me.DateTimeField(default=dt.datetime.utcnow, required=True)
        operation_id = me.StringField()

    #: account id
    id = me.StringField(db_field="account_id")
    #: folder id
    folder_id = me.StringField()
    #: account version
    version = me.IntField(default=0, db_field="account_version")
    #: last update
    last_update = me.EmbeddedDocumentField(LastUpdate)
