import datetime as dt

import mongoengine as me

from . import base


class Service(base.ConnectionSwitcherMixin, me.Document):
    """
    Misc collection to store service thread state.
    """
    class Time(me.EmbeddedDocument):
        """ Sub-document encapsulates all the database timestamps. """
        #: Last execution time.
        last_run = me.DateTimeField(required=True, default=dt.datetime.utcnow)
        #: Next execution time.
        next_run = me.DateTimeField(required=True, default=dt.datetime.utcnow)

    #: Service thread name.
    name = me.StringField(primary_key=True)
    #: Various timestamps.
    time = me.EmbeddedDocumentField(Time, required=True)
    #: Last execution host ID.
    host = me.StringField(required=True)
    #: Service-specific custom data.
    context = me.DictField()
    #: notification time (in minutes) after service freezes
    timeout = me.IntField()
    #: Sub-threads execution times and statistics, if the process has these
    threads = me.DictField()
