import mongoengine as me

import sandbox.common.types.task as ctt
from sandbox.yasandbox.database.mapping import base


class BaseEvent(base.ConnectionSwitcherMixin, me.Document):
    meta = {
        "abstract": True
    }

    # event datetime
    created = me.DateTimeField(db_field="cr", required=True)


class TaskStatusEvent(BaseEvent):
    """
    Temporal queue to send Task status change notifications to external systems.
    """

    meta = {
        "indexes": [
            "created"
        ]
    }

    # task entity reference
    task_id = base.ReferenceField(db_field="tid", required=True)
    # task status
    status = me.StringField(choices=list(ctt.Status), db_field="st", required=True)
    # task tags; these values needs to be captured at the moment of the event because they are mutable.
    tags = me.ListField(me.StringField())
    # task hints
    hints = me.ListField(me.StringField(), db_field="h")
