# coding: utf-8

import mongoengine as me

from . import base


class Vault(base.ConnectionSwitcherMixin, me.Document):
    """
        Mapping class between Python objects and "vault" collection in database.
    """

    meta = {
        "indexes": [
            {"fields": ["owner", "allowed_users"]},
            {"fields": ["owner", "name"], "unique": True}
        ]
    }

    # primary key
    id = me.SequenceField(primary_key=True)

    # owner of the data
    owner = me.StringField(required=True)

    # name of data
    name = me.StringField(required=True)

    # list of users allowed to use the data
    allowed_users = me.ListField(me.StringField())

    # data
    data = me.BinaryField(required=True, max_bytes=65536)

    # whether the data is encrypted (SANDBOX-4661)
    encrypted = me.BooleanField(default=True)

    # description of vault record
    description = me.StringField(default="")
