# coding: utf-8

import mongoengine as me

from . import base


class YavToken(base.ConnectionSwitcherMixin, me.Document):
    """
    Encrypted delegation tokens from Yandex Vault
    """

    meta = {
        "indexes": [
            {"fields": ["secret_uuid"]},
        ]
    }

    # user who delegated the token
    author = me.StringField(required=True)

    # secret uuid
    secret_uuid = me.StringField(required=True)

    # encrypted delegration token
    token = me.BinaryField(required=True, max_bytes=65536)

    # token signature
    signature = me.StringField()
