import mongoengine

from sandbox import common

from . import base


class AddRevisionField(base.UpgradeStep):
    """
    Adds field 'revision' to the clients
    """

    def main(self):
        collection = mongoengine.connection.get_db()["client"]
        pbar = common.console.ProgressBar("Updating data", collection.count())
        for i, row in enumerate(collection.find({"revision": {"$exists": False}}, {"_id": 1})):
            collection.update(
                {"_id": row["_id"]},
                {"$set": {"revision": 0}}
            )
            pbar.update(i)
        pbar.finish()
