from sandbox.common import console


def drop_field(collection, field, chunk=100000):
    """
    A special helper to drop a field from any document in the collection.
    This helper has been created to support this operation over a sharded MongoDB cluster, because it obviously
    does not support action like `db.collection.update({}, {'$unset': {'field': True}})`, which faults by `mongos`
    instance because of timed out waiting response from shard(s).
    """
    with console.LongOperation("Dropping '{}.{}' field. This can take a while".format(collection.name, field)) as op:
        while True:
            ids = collection.find(spec={field: {'$exists': True}}, fields=('_id',), limit=chunk)
            ids = [r['_id'] for r in ids]
            if not ids:
                break
            collection.update({'_id': {'$in': ids}}, {'$unset': {field: True}}, multi=True)
            op.intermediate('A chunk of {} records updated.'.format(len(ids)))
