from mongoengine import connection

from . import base


class UpdateEnqueueTimeStatistics(base.UpgradeStep):
    """
    Update last hour queue time statistics to per status version
    """
    COLLECTION_NAME = "statistics"
    FIELD_NAME = "last_hour_timings"

    def _process(self, collection):
        query = {"_id": "ENQUEUE_TIME"}
        doc = collection.find_one(query)
        if not doc:
            return
        data = []
        for delta in doc.get("data", {}).get(self.FIELD_NAME, []):
            data.append({"TOTAL": delta})
        collection.update(query, {"$set": {"data.{}".format(self.FIELD_NAME): data}})

    def main(self):
        self._process(connection.get_db()[self.COLLECTION_NAME])
