import bson.binary
import mongoengine

from sandbox import common
import sandbox.common.types.misc as ctm

from . import base


class EncryptSecrets(base.UpgradeStep):
    """
    Encrypt data in vault collection (default key path is ${common.dirs.runtime}/.vault_key)
    """

    def pre(self):
        keyfile_setting = common.config.Registry().server.encryption_key
        if keyfile_setting is None:
            return

        key = common.utils.read_settings_value_from_file(keyfile_setting, ignore_file_existence=True, binary=True)
        if key is None and common.config.Registry().common.installation == ctm.Installation.LOCAL:
            key = common.crypto.AES.generate_key(common.utils.to_path(keyfile_setting))

        encryptor = common.crypto.AES(key)
        collection = mongoengine.connection.get_db()["vault"]
        pbar = common.console.ProgressBar("Encrypting secrets", collection.count())
        for i, row in enumerate(collection.find(
            {"encrypted": {"$exists": False}},
            {"_id": 1, "data": 1}
        )):
            encrypted = encryptor.encrypt(row["data"], use_base64=False, use_salt=True)
            collection.update(
                {"_id": row["_id"]},
                {"$set": {"data": bson.binary.Binary(encrypted), "encrypted": True}}
            )
            pbar.update(i)
        pbar.finish()

    def main(self):
        pass
