from sandbox.yasandbox import controller
from sandbox.yasandbox.database import mapping

import sandbox.yasandbox.proxy.client as proxy_client


class ClientManager(object):
    remoteName = 'client'

    def __init__(self):
        mapping.Client.ensure_indexes()

    @staticmethod
    def create(
        hostname, freespace=0, update_ts=0, arch='', model='', ncpu=0, ram=0,
        info=None, reloading=None, pending_commands=None
    ):
        return proxy_client.Client(
            hostname, freespace, update_ts, arch, model, ncpu, ram, info, reloading, pending_commands
        ).save()

    @staticmethod
    def update(client):
        client.save()

    @classmethod
    def load(cls, host, create=False):
        mp = mapping.Client.objects(hostname=host).first()
        if mp:
            return proxy_client.Client.restore(mp)
        return cls.create(host) if create else proxy_client.Client(host)

    @staticmethod
    def load_list(ids):
        objects = mapping.Client.objects.in_bulk(ids)
        return map(proxy_client.Client.restore, map(objects.get, ids))

    @staticmethod
    def list(
        hostname=None, freespace=None, update_ts=None, arch=None, model=None, ncpu=None, ram=None, count=False,
        tags=None
    ):
        query = controller.Client.list_query(hostname, freespace, update_ts, arch, model, ncpu, ram, tags)
        return (
            query.count()
            if count else
            [proxy_client.Client.restore(mp) for mp in query.order_by('hostname')]
        )

    @classmethod
    def reload_all(cls, reloading=mapping.Client.Reloading.RESTART):
        for client in cls.list():
            client.reload(reloading)

    @staticmethod
    def reset_host_tasks(logger, hosts):
        return controller.Client.reset_host_tasks(logger, hosts)
