import sandbox.common.types.notification as ctn

from sandbox.yasandbox import controller
from sandbox.yasandbox.database import mapping


class NotificationManager(object):
    """
    Manager for standard operations on Notification objects
    """

    Model = mapping.Notification

    remoteName = 'notification'
    Type = ctn.Type
    Transport = ctn.Transport
    Charset = ctn.Charset

    def __init__(self):
        self.Model.ensure_indexes()

    @classmethod
    def notification(cls, transport, statuses, *recipients):
        return controller.Notification.notification(transport, statuses, recipients)
