import common.log

import yasandbox.controller
import yasandbox.services.zk
import yasandbox.database.mapping


# noinspection PyProtectedMember
class Core(yasandbox.services.zk.ThreadWithZK):
    def __init__(self, *args, **kwargs):
        super(Core, self).__init__(*args, **kwargs)
        self.run_interval = 60  # sec
        self.logger = common.log.get_core_log("core")

    def _proc(self):
        if self.stopping():
            return
        yasandbox.controller.TaskQueue.check_enqueued_tasks(self.logger)
