# -*- coding: utf-8 -*-
import argparse
import os
import time
import logging

import updater

logging.basicConfig(level=logging.INFO)

if __name__ == '__main__':
    parser = argparse.ArgumentParser(
        formatter_class=argparse.RawDescriptionHelpFormatter,
        description='''\033[92mSSH keys updater.\x1b[0m\n''')
    parser.add_argument('-d', '--database', required=True, help='Name of the database to use')
    parser.add_argument('-e', '--endpoint', required=True, help='Endpoint url to use')
    parser.add_argument('-p', '--path', default='')

    auth_token = os.environ.get('AUTH_TOKEN')
    if not auth_token:
        raise Exception('Empty $AUTH_TOKEN')

    args = parser.parse_args()
    logger = logging.getLogger('ssh-keys')
    while 1:
        logger.info('new loop')
        updater.run(
            endpoint=args.endpoint,
            database=args.database,
            path=args.path,
            auth_token=auth_token,
        )
        time.sleep(30*60)
