#include "common.h"

namespace NStringUtils {
    bool IsHash(const TStringBuf data) {
        if (data.size() % 2 != 0) {
            // hash string must be multiple of 2
            return false;
        }

        bool haveLower = false;
        bool haveDigit = false;
        for (const auto& ch : data) {
            if ('0' <= ch && ch <= '9') {
                haveDigit = true;
            } else if ('a' <= ch && ch <= 'f') {
                haveLower = true;
            } else {
                return false;
            }
        }

        // by statistic hash probably contain lower chars and digit
        return haveLower && haveDigit;
    }

    bool IsBase64(const TStringBuf data) {
        if (data.size() % 4 != 0) {
            // Base64 string must be multiple of 4
            return false;
        }

        bool haveUpper = false;
        bool haveLower = false;
        for (const auto& ch : data) {
            if ('0' <= ch && ch <= '9') {
                // pass
            } else if ('a' <= ch && ch <= 'z') {
                haveLower = true;
            } else if ('A' <= ch && ch <= 'Z') {
                haveUpper = true;
            } else if (ch == '+' || ch == '/' | ch == '=') {
                // pass
            } else {
                return false;
            }
        }

        // by statistic base64 probably contain lower/upper char and digit
        return haveUpper && haveLower;
    }

    bool IsBase64Url(const TStringBuf data) {
        bool haveUpper = false;
        bool haveLower = false;
        for (const auto& ch : data) {
            if ('0' <= ch && ch <= '9') {
                // pass
            } else if ('a' <= ch && ch <= 'z') {
                haveLower = true;
            } else if ('A' <= ch && ch <= 'Z') {
                haveUpper = true;
            } else if (ch == '*' || ch == '-' | ch == '_') {
                // pass
            } else {
                return false;
            }
        }

        // by statistic base64 probably contain lower and upper chars
        return haveUpper && haveLower;
    }

    bool IsBase64UrlRaw(const TStringBuf data) {
        bool haveUpper = false;
        bool haveLower = false;
        for (const auto& ch : data) {
            if ('0' <= ch && ch <= '9') {
                // pass
            } else if ('a' <= ch && ch <= 'z') {
                haveLower = true;
            } else if ('A' <= ch && ch <= 'Z') {
                haveUpper = true;
            } else if (ch == '*' || ch == '-' | ch == '_' || ch == '=') {
                // pass
            } else {
                return false;
            }
        }

        // by statistic base64 probably contain lower and upper chars
        return haveUpper && haveLower;
    }

    bool IsBase64UrlEven(const TStringBuf data) {
        if (data.size() % 4 != 0) {
            // Base64 string must be multiple of 4
            return false;
        }

        return IsBase64UrlRaw(data);
    }

    bool IsMasked(const TStringBuf data, size_t maskLen) {
        size_t start = data.size()-maskLen;
        for (size_t i = ++start; i < data.size(); ++i) {
            if (data[i-1] != data[i]) {
                return false;
            }
        }

        return true;
    }
}
