#include <security/ant-secret/internal/string_utils/common.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TCommonTests) {
    using namespace NStringUtils;

    Y_UNIT_TEST(IsHash) {
        UNIT_ASSERT(IsHash("a94a8fe5ccb19ba61c4c0873d391e987982fbbd3"));
        UNIT_ASSERT(IsHash("9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08"));
        UNIT_ASSERT(!IsHash("abcd"));
        UNIT_ASSERT(!IsHash("12345678901234567890123456789012"));
        UNIT_ASSERT(!IsHash("a94a8fe5ccb19ba61c4c0873d391e987982fbbd31"));
        UNIT_ASSERT(!IsHash("!94a8fe5ccb19ba61c4c0873d391e987982fbbd3"));
    }

    Y_UNIT_TEST(IsBase64) {
        UNIT_ASSERT(IsBase64("dGVzdHN0aW5n"));
        UNIT_ASSERT(IsBase64("dGVzdHN0aW5nMQ=="));
        UNIT_ASSERT(!IsBase64("!GVzdHN0aW5nMQ=="));
        UNIT_ASSERT(!IsBase64("abc"));
        UNIT_ASSERT(!IsBase64("rTCH8cLoGxAm_xw68z-zXVKi9ie6xJn9tnVWjd_9ftE"));
    }

    Y_UNIT_TEST(IsBase64Url) {
        UNIT_ASSERT(IsBase64Url("eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
        UNIT_ASSERT(IsBase64Url("eyJzdWIiOiIxIn0"));
        UNIT_ASSERT(IsBase64Url("rTCH8cLoGxAm_xw68z-zXVKi9ie6xJn9tnVWjd_9ftE"));
        UNIT_ASSERT(!IsBase64Url("abcd"));
        UNIT_ASSERT(!IsBase64Url("dGVzdHN0aW5nMQ=="));
    }

    Y_UNIT_TEST(IsBase64UrlEven) {
        UNIT_ASSERT(IsBase64UrlEven("eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
        UNIT_ASSERT(IsBase64UrlEven("dGVzdHN0aW5nMQ=="));
    }

    Y_UNIT_TEST(IsBase64UrlRaw) {
        UNIT_ASSERT(IsBase64UrlEven("eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"));
        UNIT_ASSERT(IsBase64UrlEven("dGVzdHN0aW5nMQ=="));
    }
}
