#include <security/ant-secret/internal/string_utils/entropy.h>

#include <library/cpp/testing/unittest/registar.h>

namespace {
    const char kGenericTable[] = {
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0, // \x00...\x0f
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0, // \x10...\x1f

        //         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,

        //      0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        0,
        0,
        0,
        0,
        0,
        0,

        //      @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O
        0,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,

        //      P  Q  R  S  T  U  V  W  X  Y  Z  [  \\  ]  ^  _
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        0,
        0,
        0,
        0,
        0,

        //      `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o
        0,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,

        //      p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~  x7f
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        0,
        0,
        0,
        0,
        0,

        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
    };

}

Y_UNIT_TEST_SUITE(TShannonEntropy) {
    using namespace NStringUtils;

    Y_UNIT_TEST(ValidRunes) {
        UNIT_ASSERT(ShannonEntropy("test", kGenericTable) > 0.0f);
        UNIT_ASSERT(ShannonEntropy("TEST123", kGenericTable) > 0.0f);
    }

    Y_UNIT_TEST(InvalidRunes) {
        UNIT_ASSERT(ShannonEntropy("!test", kGenericTable) <= 0.5f);
        UNIT_ASSERT(ShannonEntropy("test!", kGenericTable) <= 0.5f);
        UNIT_ASSERT(ShannonEntropy("te!st", kGenericTable) <= 0.5f);
    }

    Y_UNIT_TEST(Calc) {
        const auto sha1 = ShannonEntropy("a94a8fe5ccb19ba61c4c0873d391e987982fbbd3", kGenericTable);
        UNIT_ASSERT(sha1 > 3.0f && sha1 < 4.0f);

        const auto sha256 = ShannonEntropy("9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08",
                                           kGenericTable);
        UNIT_ASSERT(sha256 > 3.0f && sha256 < 4.0f);

        const auto test = ShannonEntropy("test", kGenericTable);
        UNIT_ASSERT(test > 1.0f && test < 2.0f);
    }
}
