#include "options.h"

#include <library/cpp/getopt/last_getopt.h>
#include <util/string/vector.h>
#include <util/string/strip.h>
#include <util/string/join.h>
#include <util/system/env.h>

namespace NMaskerServer {
    const TProgramOptions TProgramOptions::Parse(int argc, char** argv) {
        auto options = TProgramOptions();

        using namespace NLastGetopt;
        TOpts opts = TOpts::Default();

        opts.SetTitle("SecretSearchServer server");

        opts.AddLongOption("addr", "server addr to bind")
                .RequiredArgument("HOST:PORT")
                .DefaultValue("localhost:10203")
                .StoreResult(&options.ServerAddr);

        opts.AddLongOption("with-validation", "enable validation")
                .NoArgument();

        TOptsParseResult args(&opts, argc, argv);
        options.ValidateSecrets = args.Has("with-validation");
        return options;
    }

    void TProgramOptions::Print(IOutputStream& out) {
        out
                << "ServerAddr = " << ServerAddr << Endl;
    }

    const TServerOptions TProgramOptions::ServerOptions() const {
        return TServerOptions{
                .ValidateSecrets = ValidateSecrets,
                .ServerAddr = ServerAddr,
        };
    }

}
