#pragma once

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <library/cpp/http/server/http.h>
#include <library/cpp/http/server/response.h>

#include <security/ant-secret/snooper/cpp/snooper.h>


namespace NMaskerServer {
    struct TServerOptions {
        bool ValidateSecrets;
        TString ServerAddr;
    };

    void StartServer(const TServerOptions& opts);

    class TMaskReplier: public TRequestReplier {
    public:
        explicit TMaskReplier(bool validateSecrets) : validateSecrets(validateSecrets) {};

        bool DoReply(const TReplyParams& params) override;
    private:
        const bool validateSecrets;
        NSnooper::TSnooper snooper;
    };

    class THttpCallback: public THttpServer::ICallBack {
    public:
        explicit THttpCallback(bool validateSecrets): validateSecrets(validateSecrets) {}

        TClientRequest* CreateClient() override {
            return new TMaskReplier(validateSecrets);
        }

    protected:
        const bool validateSecrets;
    };

}
