#include "options.h"

#include <security/ant-secret/secret-search/public/cpp/searcher_stream.h>
#include <security/ant-secret/secret-search/public/cpp/source.h>

#include <library/cpp/svnversion/svnversion.h>
#include <library/cpp/json/json_reader.h>
#include <contrib/libs/openssl/include/openssl/rsa.h>
#include <security/libs/cpp/log/log.h>

using namespace NSecretSearch;
using namespace NSecretSearch::NBin;

namespace {
    TString kVersion = "0.8." + ToString(GetProgramSvnRevision());
}

int main(int argc, char** argv) {
    auto options = TOptions::Parse(argc, argv);

    if (options.ShowVersion) {
        Cout << kVersion << Endl;
        return 0;
    }

    if (options.Verbose) {
        Cerr << "Started with options:" << Endl;
        options.Print(Cerr);
        Cerr << "Build info: " << Endl;
        Cerr << GetProgramSvnVersion() << Endl;
        NSecurityHelpers::TLogger::Instance(NSecurityHelpers::TLOG_DEBUG);
    }

    try {
        // TODO(buglloc): hack :(
        // Remove after update to openssl-1.1.0h
        RSA_get_default_method();

        bool somethingFound = false;
        if (options.CheckStructMode) {
            // check json struct
            NJson::TJsonValue root;
            if (options.InputPath == "-") {
                NJson::ReadJsonTree(&Cin, true, &root, true);
            } else {
                TFileInput in(options.InputPath);
                NJson::ReadJsonTree(&in, true, &root, true);
            }

            TSearcherStream searcher(options.SearcherOptions(), options.OutputWriter());
            somethingFound = searcher.CheckStruct(root);
        } else {
            if (options.InputPath == "-") {
                // stdin
                options.NumThreads = 1;
                TSearcherStream searcher(options.SearcherOptions(), options.OutputWriter());
                TSourceContent source(Cin.ReadAll());
                somethingFound = searcher.CheckSource(source);
            }  else if (options.NumThreads > 1) {
                TSearcherStreamThreaded searcher(options.SearcherOptions(), options.OutputWriter(), options.NumThreads);
                somethingFound = searcher.CheckPath(options.InputPath);
            } else {
                TSearcherStream searcher(options.SearcherOptions(), options.OutputWriter());
                somethingFound = searcher.CheckPath(options.InputPath);
            }
        }

        if (somethingFound) {
            return options.StatusCode;
        }
    } catch (const TSystemError& e) {
        NSecurityHelpers::LogErr("Failed to search secret", "err", e.AsStrBuf());
        return 1;
    }

    return 0;
}
