#pragma once

#include <security/ant-secret/secret-search/public/cpp/searcher.h>
#include <security/ant-secret/secret-search/public/cpp/output/interface.h>

#include <util/system/defaults.h>
#include <util/stream/output.h>
#include <util/generic/vector.h>

namespace NSecretSearch::NBin {
    class TOptions {
    public:
        bool Validate = false;
        bool ValidOnly = false;
        bool Verbose = false;
        bool ShowVersion = true;
        bool WithSourceLine = false;
        bool CheckStructMode = false;
        int StatusCode = 3;
        size_t NumThreads = 4;
        size_t MaxFileSize = 3 * 1024 * 1024;
        TVector<TString> Excludes = {
            ".arc",
            ".git",
            ".hg",
            ".svn",
            ".venv",
            ".venv3",
            "node_modules",
            "tmp"};
        TString InputPath = ".";
        TString OutFormat = "auto";

    public:
        static TOptions Parse(int argc, char** argv);

        void Print(IOutputStream& out);

        [[nodiscard]] TSearchOptions SearcherOptions() const;

        [[nodiscard]] NOutput::IWriter* OutputWriter() const;
    };

}
