#pragma once

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/set.h>
#include <util/datetime/base.h>

namespace NSecretSearchGitHook {
    class TProgramOptions {
    public:
        bool Colorized = false;
        bool RealRun = false;
        bool Verbose = false;
        bool EachRev = false;
        bool CheckPrivate = false;
        bool RestrictSource = true;
        bool SkipKnownSecrets = true;
        bool SkipKnownRevs = true;
        bool ShowVersion = true;
        TSet<TString> SafeLogins = {
            "robot-yadi",
            "robot-merge-queue",
            "robot-serp-bot",
            "robot-frontend",
            "lego-changelogger"
        };
        size_t NumThreads = 4;
        TDuration Timeout;

        void Print(IOutputStream& out);

        static const TProgramOptions Parse(int argc, char** argv);

        const TList<TString> Args(bool addRealRun = false, bool addColorized = false) const;
    };

}
