#pragma once

#include <util/generic/string.h>
#include <util/generic/strbuf.h>
#include <util/generic/deque.h>
#include <util/generic/yexception.h>

namespace NSecretSearchGitHook {
    struct TDiffLine {
        size_t LineNo = 0;
        TString Line;

        TDiffLine(size_t LineNo, TString Line)
            : LineNo(LineNo)
            , Line(std::move(Line)){};
    };

    struct TDiff {
        TString CommitId;
        TString SourceFile;
        TString TargetFile;
        bool Fulfilled = false;
        TDeque<TDiffLine> Removed;
        TDeque<TDiffLine> Added;
    };

    using TPatchSet = TDeque<TDiff>;

}
