#pragma once

#include "diff.h"
#include <security/ant-secret/secret-search/internal/source.h>

namespace NSecretSearchGitHook {
    class TSourceDiff: public NSSInternal::ISource {
    public:
        TSourceDiff(const TString& path, const TDeque<TDiffLine>& lines, bool fulfilled, const TString& commitId);

        const TStringBuf Head(size_t len) override;

        const TStringBuf Content() override;

        const TFsPath Path() override;

        const TString CommitId();

        bool IsBinary() override;

        bool IsLocal() override;

        bool IsFulfilled() override;

        bool ReadLine(size_t& lineNo, TStringBuf& line) override;

        size_t Size() override;

        static TSourceDiff FromDiff(const TDiff& diff);

    protected:
        size_t size = 0;
        size_t curLine = 0;
        const TFsPath path;
        const TDeque<TDiffLine> lines;
        bool fulfilled = false;
        TString commitId;
        TString content;
    };

}
