#pragma once

#include "diff.h"

namespace NSecretSearchGitHook {
    namespace NGit {
        using TDiffWalkCb =
            std::function<bool(TDiff
                                   diff)>;

        class TDiffWalker {
        public:
            explicit TDiffWalker(const TString& repoPath)
                : repoPath(repoPath)
            {
            }

            void SetSkipKnown(bool skip) {
                skipKnown = skip;
            }

            void DiffWalk(const TString& revA, const TString& revB, const TDiffWalkCb& cb);

            void RevsWalk(const TString& revA, const TString& revB, const TDiffWalkCb& cb);

        protected:
            const TString& repoPath;
            bool skipKnown = false;
        };

    }
}
