#include "output.h"

#include <security/ant-secret/secret-search/public/cpp/secret.h>

#include <util/string/builder.h>

namespace NSecretSearchGitHook {
    void TOutput::Write(const TDiffResult& result) {
        TStringBuilder outB;

        if (result.CommitId) {
            outB << "- commit \"" << result.CommitId << "\":" << Endl;
        }

        for (const auto& secret : result.SearcherResults) {
            auto info = secret.ShortAdditional();
            outB
                << "\t"
                << "/" << result.Path
                << ":"
                << secret.LineNo
                << ": "
                << secret.HumanType();

            if (info) {
                outB << " (" << info << ")";
            }

            outB << Endl;
        }

        with_lock (outMutex) {
            if (!headerPrinted) {
                out
                    << "[POLICY BLOCKED] It seems that your commit contains passwords, tokens or other secrets." << Endl
                    << "More information at wiki: https://wiki.yandex-team.ru/security/secrets/github-hook/" << Endl;
                headerPrinted = true;
            }

            out << outB;
        }
    }

}
